<?php
require_once __DIR__.'/constants.php';

/**
 * Clean input
 */
function clean($data){
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

/**
 * Generate Random Token
 */
function randomToken($length = 32){
    return bin2hex(random_bytes($length));
}

/**
 * Format currency
 */
function money($amount, $currency = DEFAULT_CURRENCY){
    return number_format($amount). ' ' . $currency;
}

/**
 * Redirect
 */
function redirect($url){
    header("Location: $url");
    exit;
}

/**
 * Get Client IP
 */
function getIP(){
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

/**
 * Distance between 2 points (Haversine KM)
 */
function calculateDistance($lat1, $lon1, $lat2, $lon2){
    $earth_radius = 6371;
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat/2) * sin($dLat/2) +
           cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
           sin($dLon/2) * sin($dLon/2);
    $c = 2 * atan2(sqrt($a), sqrt(1-$a));
    return round($earth_radius * $c, 2);
}

/**
 * Generate order number
 */
function generateOrderNumber(){
    return "MD-" . time() . rand(100,999);
}

/**
 * JSON response helper
 */
function jsonResponse($data, $status = 200){
    http_response_code($status);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}
?>
