<?php
require_once "../includes/config.php";
require_once "../includes/response.php";

$restaurant_id = $_GET['restaurant_id'] ?? 0;

$cats = $pdo->prepare("SELECT * FROM categories WHERE restaurant_id=? AND status=1 ORDER BY sort_order");
$cats->execute([$restaurant_id]);

$categories = [];

while($cat = $cats->fetch(PDO::FETCH_ASSOC)){
    
    $items = $pdo->prepare("SELECT * FROM items WHERE category_id=? AND status=1 ORDER BY sort_order");
    $items->execute([$cat['id']]);
    $itemData = [];

    while($item = $items->fetch(PDO::FETCH_ASSOC)){
        $extras = $pdo->prepare("SELECT name_ar,price FROM extras WHERE item_id=?");
        $extras->execute([$item['id']]);

        $item['extras'] = $extras->fetchAll(PDO::FETCH_ASSOC);
        $itemData[] = $item;
    }

    $cat['items']=$itemData;
    $categories[]=$cat;
}

response($categories);

