<?php
require_once "../includes/config.php";
require_once "../includes/auth.php";
require_once "../includes/response.php";

$user = requireAuth();

if(!in_array($user->role,['manager','cashier','super'])){
    response(['error'=>'Forbidden'],403);
}

$data = json_decode(file_get_contents("php://input"),true);

$order_id = $data['order_id'];
$status   = $data['status'];

$allowed = ['new','preparing','ready','on_delivery','completed','cancelled'];

if(!in_array($status,$allowed)){
    response(['error'=>'Invalid status'],422);
}

$pdo->prepare("
UPDATE orders SET status=?, updated_at=NOW()
WHERE id=?
")->execute([$status,$order_id]);

if($status === 'completed'){
    $pdo->prepare("
      UPDATE drivers 
      SET status='returned' 
      WHERE id = (SELECT driver_id FROM orders WHERE id=?)
    ")->execute([$order_id]);
}

response(['success'=>true]);
