<?php
require_once "../includes/config.php";
require_once "../includes/response.php";
require_once "../includes/validators.php";
require_once "../includes/block-system.php";
require_once "../includes/assign-driver.php";
require_once "../../shared/helpers.php";

$data = json_decode(file_get_contents("php://input"), true);

$restaurant_id = $data['restaurant_id'];
$name = $data['name'];
$phone = $data['phone'];
$lat = $data['lat'];
$lng = $data['lng'];
$items = $data['items'];

if(!required($name) || !phoneValid($phone)){
    response(['error'=>'Invalid data'],422);
}

# تحقق من الحظر
$check = $pdo->prepare("
    SELECT is_blocked FROM blocked_customers
    WHERE restaurant_id=? AND customer_phone=?
");
$check->execute([$restaurant_id,$phone]);
if($check->fetchColumn()){
    response(['error'=>'Customer blocked'],403);
}

# موقع المطعم
$res = $pdo->prepare("SELECT lat,lng,max_distance_km FROM restaurants WHERE id=?");
$res->execute([$restaurant_id]);
$restaurant = $res->fetch();

$distance = calculateDistance(
    $restaurant['lat'],
    $restaurant['lng'],
    $lat,
    $lng
);

if($distance > $restaurant['max_distance_km']){
    response(['error'=>'Out of service area'],403);
}

# سعر التوصيل
$priceStmt = $pdo->prepare("
    SELECT price FROM delivery_pricing 
    WHERE restaurant_id=? AND ? BETWEEN from_km AND to_km
    LIMIT 1
");
$priceStmt->execute([$restaurant_id,$distance]);
$delivery = $priceStmt->fetchColumn() ?? 0;

# الحساب
$subtotal = 0;
foreach($items as $i){
    $subtotal += $i['price'] * $i['qty'];
}
$total = $subtotal + $delivery;

# سائق تلقائي (متاح / عائد)
$driver_id = assignDriver($pdo,$restaurant_id);

$pdo->prepare("
INSERT INTO orders 
(restaurant_id,customer_name,customer_phone,customer_lat,customer_lng,
distance_km,delivery_fee,subtotal,total,driver_id,status)
VALUES (?,?,?,?,?,?,?,?,?,?,?)
")->execute([
   $restaurant_id,$name,$phone,$lat,$lng,
   $distance,$delivery,$subtotal,$total,
   $driver_id,
   $driver_id ? 'on_delivery' : 'new'
]);

$order_id = $pdo->lastInsertId();

# عناصر الطلب
foreach($items as $i){
   $pdo->prepare("
   INSERT INTO order_items 
   (order_id,item_name,qty,unit_price,total_price)
   VALUES (?,?,?,?,?)
   ")->execute([
       $order_id,
       $i['name'],
       $i['qty'],
       $i['price'],
       $i['price']*$i['qty']
   ]);
}

# تعديل حالة السائق
if($driver_id){
    $pdo->prepare("UPDATE drivers SET status='busy' WHERE id=?")
    ->execute([$driver_id]);
}

response([
    'success'=>true,
    'order_id'=>$order_id,
    'driver_assigned'=>$driver_id ? true : false,
    'distance'=>$distance,
    'delivery_fee'=>$delivery,
    'total'=>$total
]);
