<?php
require_once "../includes/config.php";
require_once "../includes/auth.php";
require_once "../includes/response.php";

$user = requireAuth();

if($user->role !== 'driver'){
   response(['error'=>'Forbidden'],403);
}

$stmt = $pdo->prepare("
SELECT * FROM orders
WHERE driver_id = (SELECT id FROM drivers WHERE user_id=?)
AND status IN ('on_delivery','ready')
");
$stmt->execute([$user->id]);

response($stmt->fetchAll(PDO::FETCH_ASSOC));

