<?php
require_once "../includes/config.php";
require_once "../includes/response.php";
require_once "../includes/validators.php";

$data = json_decode(file_get_contents("php://input"),true);

$order_id = $data['order_id'];
$rating = $data['rating'];
$comment = $data['comment'] ?? '';

$stmt = $pdo->prepare("SELECT restaurant_id,customer_phone FROM orders WHERE id=?");
$stmt->execute([$order_id]);
$order = $stmt->fetch();

if(!$order) response(['error'=>'Order not found'],404);

$pdo->prepare("
INSERT INTO ratings (restaurant_id,order_id,customer_phone,rating,comment)
VALUES (?,?,?,?,?)
")->execute([$order['restaurant_id'],$order_id,$order['customer_phone'],$rating,$comment]);

response(['success'=>true]);

